document.addEventListener('DOMContentLoaded', function () {
    // Atrodam formu un pogu
    const form = document.querySelector('form');
    const submitButton = document.querySelector('button[type="submit"]');

    // Formas validācija
    form.addEventListener('submit', function (event) {
        // Iegūstam formu datus
        const name = document.getElementById('name').value.trim();
        const companyId = document.getElementById('company_id').value;
        const phone = document.getElementById('phone').value.trim();
        const date = document.getElementById('date').value.trim();
        const remaining = document.getElementById('remaining').value.trim();

        // Pārbauda, vai visi nepieciešamie lauki ir aizpildīti
        if (!name || !companyId || !phone || !date || !remaining) {
            alert('Lūdzu, aizpildiet visus laukus!');
            event.preventDefault();
            return;  // Aptur turpmāko kodu izpildi, ja lauki nav aizpildīti
        }

        // Pārliecināmies, ka tālruņa numurs ir pareizs (vienkārša pārbaude)
        const phonePattern = /^[0-9]{8,12}$/;
        if (!phonePattern.test(phone)) {
            alert('Lūdzu, ievadiet derīgu telefona numuru!');
            event.preventDefault();
            return;
        }

        // Papildus validācija - datumam jābūt derīgam formātā yyyy-mm-dd
        const datePattern = /^\d{4}-\d{2}-\d{2}$/;
        if (!datePattern.test(date)) {
            alert('Lūdzu ievadiet datumu formātā yyyy-mm-dd.');
            event.preventDefault();
            return;
        }

        // Pārbauda atlikušās reizes - jābūt pozitīvam skaitlim
        if (isNaN(remaining) || remaining < 0) {
            alert('Atlikušajām reizēm jābūt pozitīvam skaitlim!');
            event.preventDefault();
            return;
        }
    });

    // Ievietojam dzēšanas apstiprinājumu
    const deleteButtons = document.querySelectorAll('.delete-btn');
    deleteButtons.forEach(button => {
        button.addEventListener('click', function (event) {
            const confirmDelete = confirm("Vai tiešām vēlaties dzēst šo caurlaidi?");
            if (!confirmDelete) {
                event.preventDefault(); // Atceļ pogas darbību, ja lietotājs neapstiprina
            }
        });
    });
});