// Kad lapa ir pilnībā ielādēta, izpilda šo kodu
document.addEventListener("DOMContentLoaded", () => {
    const meetingsContainer = document.getElementById("meetings-container"); // Atrod sapulču konteineru
    const meetingForm = document.getElementById("meeting-form"); // Atrod sapulces pievienošanas formu

    // Funkcija, lai ielādētu sapulces no servera
    function fetchMeetings() {
        return fetch("../../includes/get_meetings.php")
            .then(response => response.json()) // Pārvērš datus JSON formātā
            .then(data => {
                meetingsContainer.innerHTML = ""; // Notīra esošās sapulces

                if (data.length > 0) {
                    data.forEach(meeting => {
                        const meetingDiv = document.createElement("div"); // Izveido <div> sapulcei
                        meetingDiv.classList.add("meeting"); // Pievieno CSS klasi

                        // Ievieto sapulces informāciju HTML struktūrā
                        meetingDiv.innerHTML = `
                            <h3>${meeting.title}</h3>
                            <p>Datums un laiks: ${meeting.meeting_date}</p>
                            ${
                            meeting.reminder_time
                                ? `<p>Atgādinājums: ${meeting.reminder_time}</p>` // Ja ir atgādinājums
                                : `<p>Atgādinājums nav iestatīts.</p>` // Ja atgādinājuma nav
                        }
                        `;

                        meetingsContainer.appendChild(meetingDiv); // Pievieno sapulci konteineram
                    });
                } else {
                    meetingsContainer.innerHTML = "<p>Nav ieplānotu sapulču.</p>"; // Ja sapulču nav
                }
            })
            .catch(error => console.error("Kļūda ielādējot sapulces:", error)); // Apstrādā kļūdas gadījumā
    }

    // Ielādē sapulces, kad lapa tiek ielādēta
    fetchMeetings();

    // Apstrādā sapulces pievienošanas formu
    meetingForm.addEventListener("submit", (e) => {
        e.preventDefault(); // Novērš noklusējuma darbību
        const formData = new FormData(meetingForm); // Sagatavo formas datus

        fetch(meetingForm.action, {
            method: "POST",
            body: formData
        })
            .then(() => {
                fetchMeetings(); // Atjauno sapulču sarakstu
                meetingForm.reset(); // Notīra ievades laukus
            })
            .catch(error => console.error("Kļūda pievienojot sapulci:", error)); // Apstrādā kļūdas gadījumā
    });
});
