// Kad lapa ir pilnībā ielādēta, izpilda šo kodu
document.addEventListener("DOMContentLoaded", () => {
    const remindersContainer = document.getElementById("reminders-container"); // Atrod elementu, kurā tiks attēloti uzdevumi
    const reminderForm = document.getElementById("reminder-form"); // Atrod uzdevuma pievienošanas formu

    // Iegūst uzdevumus no servera
    function fetchReminders() {
        return fetch("../../includes/get_reminders.php")
            .then(response => response.json()) // Pārvērš saņemtos datus JSON formātā
            .then(data => {
                remindersContainer.innerHTML = ""; // Iztīra esošos uzdevumus
                if (data.length > 0) {
                    data.forEach(reminder => {
                        const reminderDiv = document.createElement("div"); // Izveido jaunu <div> uzdevumam
                        reminderDiv.classList.add("reminder"); // Pievieno klasei "reminder"

                        // Ievieto uzdevuma nosaukumu, termiņu un statusu
                        reminderDiv.innerHTML = `
                            <h3>${reminder.title}</h3>
                            <p>Termiņš: ${reminder.reminder_date}</p>
                            <p>Statuss: ${reminder.status}</p>
                            <button class="toggle-status" data-id="${reminder.id}">
                                Atzīmēt kā ${reminder.status === "pending" ? "izpildītu" : "neizpildītu"}
                            </button>
                        `;

                        remindersContainer.appendChild(reminderDiv); // Pievieno uzdevumu sarakstam
                    });
                } else {
                    remindersContainer.innerHTML = "<p>Nav uzdevumu.</p>"; // Ja uzdevumu nav, parāda paziņojumu
                }

                // Pievieno notikumu klausītājus pogām statusa maiņai
                document.querySelectorAll(".toggle-status").forEach(button => {
                    button.addEventListener("click", () => toggleStatus(button.dataset.id));
                });
            })
            .catch(error => console.error("Kļūda ielādējot uzdevumus:", error)); // Apstrādā kļūdas
    }

    // Funkcija uzdevuma statusa maiņai
    function toggleStatus(id) {
        fetch("../../includes/toggle_reminder.php", {
            method: "POST",
            headers: { "Content-Type": "application/json" },
            body: JSON.stringify({ id }) // Nosūta uzdevuma ID serverim
        })
            .then(response => response.json()) // Pārvērš atbildi JSON formātā
            .then(data => {
                if (data.success) {
                    fetchReminders(); // Pārlādē uzdevumus pēc statusa maiņas
                } else {
                    console.error("Kļūda mainot uzdevuma statusu:", data.error);
                }
            })
            .catch(error => console.error("Kļūda:", error)); // Apstrādā kļūdu
    }

    // Ielādē uzdevumus, kad lapa atveras
    fetchReminders();

    // Apstrādā formas iesniegšanu
    reminderForm.addEventListener("submit", (e) => {
        e.preventDefault(); // Novērš noklusējuma darbību
        const formData = new FormData(reminderForm); // Iegūst formas datus

        fetch(reminderForm.action, {
            method: "POST",
            body: formData // Nosūta formas datus serverim
        })
            .then(() => {
                fetchReminders(); // Pārlādē uzdevumus pēc pievienošanas
                reminderForm.reset(); // Notīra formu
            })
            .catch(error => console.error("Kļūda pievienojot uzdevumu:", error)); // Apstrādā kļūdu
    });
});
