// Kad lapa ir pilnībā ielādēta, izpilda šo kodu
document.addEventListener("DOMContentLoaded", () => {
    const notesContainer = document.getElementById("notes-container"); // Atrod elementu, kurā tiks ievietotas piezīmes

    // Iegūst piezīmes no servera
    fetch("../../includes/get_notes.php")
        .then((response) => response.json()) // Pārvērš saņemtos datus JSON formātā
        .then((notes) => {
            if (notes.length > 0) {
                notes.forEach((note) => {
                    const noteDiv = document.createElement("div"); // Izveido jaunu <div> piezīmei
                    noteDiv.classList.add("note"); // Pievieno klasei "note"

                    // Ievieto piezīmes nosaukumu, saturu un izveides datumu
                    noteDiv.innerHTML = `
                        <h3>${note.title}</h3>
                        <p>${note.content}</p>
                        <small>Izveidots: ${note.created_at}</small>
                    `;

                    notesContainer.appendChild(noteDiv); // Pievieno piezīmi piezīmju sarakstam
                });
            } else {
                notesContainer.innerHTML = "<p>Nav piezīmju.</p>"; // Ja piezīmju nav, parāda paziņojumu
            }
        })
        .catch((error) => console.error("Kļūda ielādējot piezīmes:", error)); // Apstrādā kļūdu gadījumā
});
