// Kad dokuments ir ielādēts, izpilda kodu
document.addEventListener("DOMContentLoaded", () => {
    const calendar = document.getElementById("calendar"); // Atrodam kalendāra elementu
    const eventForm = document.getElementById("event-form"); // Atrodam pasākumu ievades formu
    let events = []; // Masīvs pasākumiem

    // Funkcija, lai iegūtu pasākumus no servera
    function fetchEvents() {
        return fetch("../../includes/get_events.php")
            .then(response => response.json()) // Pārvērš saņemtos datus JSON formātā
            .then(data => {
                events = data; // Saglabā iegūtos pasākumus masīvā
                return data;
            })
            .catch(error => console.error("Kļūda ielādējot pasākumus:", error));
    }

    // Funkcija, lai ģenerētu kalendāru
    function generateCalendar(year, month) {
        calendar.innerHTML = ""; // Iztīra kalendāra saturu

        const firstDay = new Date(year, month, 1).getDay(); // Nosaka mēneša pirmās dienas nedēļas dienu
        const daysInMonth = new Date(year, month + 1, 0).getDate(); // Nosaka dienu skaitu mēnesī

        // Pievieno tukšas šūnas pirms mēneša pirmās dienas
        for (let i = 0; i < firstDay; i++) {
            const cell = document.createElement("div");
            calendar.appendChild(cell);
        }

        // Izveido šūnas katrai mēneša dienai
        for (let day = 1; day <= daysInMonth; day++) {
            const date = `${year}-${String(month + 1).padStart(2, "0")}-${String(day).padStart(2, "0")}`;
            const cell = document.createElement("div");
            cell.textContent = day; // Attēlo dienas numuru
            cell.dataset.date = date; // Saglabā datumu datu atribūtā
            cell.classList.add("calendar-cell"); // Pievieno klasei stilizāciju

            // Pārbauda, vai šim datumam ir pasākums
            const eventForDate = events.find(event => event.event_date === date);
            if (eventForDate) {
                cell.classList.add("event-cell"); // Pievieno stilizāciju pasākumiem
                cell.addEventListener("click", () => {
                    alert(`Pasākums ${date}: ${eventForDate.title}`); // Parāda pasākuma informāciju
                });
            }

            calendar.appendChild(cell); // Pievieno šūnu kalendāram
        }
    }

    // Ielādē pasākumus un izveido kalendāru pašreizējam mēnesim
    const today = new Date();
    fetchEvents().then(() => generateCalendar(today.getFullYear(), today.getMonth()));

    // Apstrādā formas iesniegšanu
    eventForm.addEventListener("submit", (e) => {
        e.preventDefault(); // Novērš noklusējuma darbību

        const date = document.getElementById("event-date").value; // Iegūst ievadīto datumu
        const title = document.getElementById("event-title").value; // Iegūst ievadīto nosaukumu

        fetch("../../includes/calendar.php", {
            method: "POST",
            headers: { "Content-Type": "application/json" },
            body: JSON.stringify({ date, title }) // Nosūta datus serverim JSON formātā
        })
            .then(response => {
                if (!response.ok) {
                    throw new Error(`HTTP kļūda! Statuss: ${response.status}`);
                }
                return response.json();
            })
            .then(data => {
                if (data.success) {
                    alert("Pasākums veiksmīgi pievienots!"); // Paziņojums lietotājam
                    fetchEvents().then(() => generateCalendar(today.getFullYear(), today.getMonth())); // Atjauno kalendāru
                } else {
                    console.error("Kļūda pievienojot pasākumu:", data.error);
                }
            })
            .catch(error => console.error("Kļūda:", error));
    });
});
