<?php
// Iekļaut datubāzes savienojumu
global $conn;
include 'db.php';

// Atkodēt JSON ievadi
$data = json_decode(file_get_contents("php://input"), true);

if (!isset($data['id'])) {
    echo json_encode(["success" => false, "error" => "Nederīgi dati"]);
    exit;
}

$id = $data['id'];

// Pārslēgt uzdevuma statusu
$stmt = $conn->prepare("UPDATE reminders SET status = CASE WHEN status = 'pending' THEN 'completed' ELSE 'pending' END WHERE id = ?");
$stmt->bind_param("i", $id);

if ($stmt->execute()) {
    echo json_encode(["success" => true]);
} else {
    echo json_encode(["success" => false, "error" => $stmt->error]);
}

$stmt->close();
$conn->close();
?>
