<?php
// Autors: [Tavs vārds]
// Mērķis: Apstrādāt reģistrācijas formu un pārbaudīt paroles drošību
// Izveides datums: [Datums]

session_start();
include '../includes/db.php'; // Iekļaut datubāzes savienojumu

if (!isset($conn) || !$conn) {
    $_SESSION['error'] = "Datubāzes savienojums neizdevās!";
    header("Location: ../public/html/register.html");
    exit();
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $username = trim($_POST['username']);
    $email = trim($_POST['email']);
    $password = $_POST['password'];
    $confirm_password = $_POST['confirm_password'];

    // Paroles drošības pārbaude
    $password_pattern = "/^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*[@$!%*?&])[A-Za-z\d@$!%*?&]{8,}$/";
    if (!preg_match($password_pattern, $password)) {
        $_SESSION['error'] = "Parolei jābūt vismaz 8 rakstzīmēm garai, jāsatur lielie un mazie burti, cipars un speciālais simbols.";
        header("Location: ../public/html/register.html");
        exit();
    }

    // Pārbaudīt, vai paroles sakrīt
    if ($password !== $confirm_password) {
        $_SESSION['error'] = "Paroles nesakrīt!";
        header("Location: ../public/html/register.html");
        exit();
    }

    // Pārbaudīt, vai e-pasts jau ir reģistrēts
    $stmt = $conn->prepare("SELECT id FROM users WHERE email = ?");
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $stmt->store_result();

    if ($stmt->num_rows > 0) {
        $_SESSION['error'] = "E-pasts jau ir reģistrēts!";
        $stmt->close();
        header("Location: ../public/html/register.html");
        exit();
    }
    $stmt->close();

    // Šifrēt paroli
    $hashed_password = password_hash($password, PASSWORD_DEFAULT);

    // Ievietot lietotāju datubāzē
    $stmt = $conn->prepare("INSERT INTO users (username, email, password) VALUES (?, ?, ?)");
    $stmt->bind_param("sss", $username, $email, $hashed_password);

    if ($stmt->execute()) {
        $_SESSION['success'] = "Reģistrācija veiksmīga! Lūdzu, pieslēdzieties.";
        header("Location: ../public/html/index.html");
    } else {
        $_SESSION['error'] = "Kļūda. Mēģiniet vēlreiz.";
        header("Location: ../public/html/register.html");
    }

    $stmt->close();
}

$conn->close();
?>
