<?php
// Iekļaut datubāzes savienojumu
global $conn;
include 'db.php';

// Sākt sesiju
session_start();

// Pārbaudīt, vai lietotājs ir pieslēdzies
if (!isset($_SESSION['username'])) {
    // Novirzīt uz pieteikšanās lapu, ja lietotājs nav pieslēdzies
    header("Location: ../html/index.html");
    exit;
}

// Iegūt sesijas datus
$username = $_SESSION['username'];
$password = "********"; // Maskēta parole attēlošanai (neobligāti)

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Profile - Organizer</title>
    <link rel="stylesheet" href="../public/css/styles.css">
    <style>
        /* Stili profila lapai */
        .profile-container {
            max-width: 600px;
            margin: 5rem auto;
            background: #fff;
            padding: 2rem;
            border-radius: 10px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }

        .profile-container h2 {
            text-align: center;
            font-size: 2rem;
            margin-bottom: 1.5rem;
            color: #6200ea;
        }

        .profile-details p {
            font-size: 1rem;
            line-height: 1.8;
        }

        .edit-button, .logout-button {
            display: block;
            margin: 1rem auto;
            width: 100%;
            max-width: 200px;
            padding: 0.8rem;
            font-size: 1rem;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            transition: background-color 0.3s ease;
        }

        .edit-button {
            background-color: #6200ea;
            color: #fff;
        }

        .edit-button:hover {
            background-color: #3700b3;
        }

        .logout-button {
            background-color: #d32f2f;
            color: #fff;
        }

        .logout-button:hover {
            background-color: #b71c1c;
        }
    </style>
</head>
<body>
<header>
    <nav>
        <ul>
            <li><a href="../public/html/main.html">Home</a></li>
            <li><a href="../public/html/calendar.html">Calendar</a></li>
            <li><a href="../includes/profile.php" class="active">Profile</a></li>
            <li><a href="../includes/logout.php">Logout</a></li>
        </ul>
    </nav>
</header>

<main>
    <div class="profile-container">
        <h2>Jūsu profils</h2>
        <div class="profile-details">
            <p><strong>Lietotājvārds:</strong> <?php echo htmlspecialchars($username); ?></p>
            <p><strong>Parole:</strong> <?php echo $password; ?></p>
        </div>
        <button class="edit-button">Rediģēt profilu</button>
        <form action="../includes/logout.php" method="POST">
            <button type="submit" class="logout-button">Izrakstīties</button>
        </form>
    </div>
</main>

<footer>
    <p>&copy; 2025 Organizer. Visas tiesības aizsargātas.</p>
</footer>
</body>
</html>
