<?php
// Iespējot kļūdu ziņošanu atkļūdošanai
global $conn;
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Iekļaut datubāzes savienojumu
include 'db.php';

// Sākt sesiju
session_start();

// Pārbaudīt, vai forma tika iesniegta
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['username'];
    $password = $_POST['password'];

    // Sagatavot un izpildīt SQL vaicājumu
    $stmt = $conn->prepare("SELECT id, password FROM users WHERE username = ?");
    $stmt->bind_param("s", $username);
    $stmt->execute();
    $result = $stmt->get_result();

    // Pārbaudīt, vai lietotājs eksistē
    if ($result->num_rows === 1) {
        $user = $result->fetch_assoc();

        // Pārbaudīt šifrēto paroli
        if (password_verify($password, $user['password'])) {
            // Veiksmīga pieteikšanās
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['username'] = $username;

            // Novirzīt uz galveno lapu
            header("Location: ../public/html/main.html");
            exit;
        } else {
            echo "<p class='error'>Nepareiza parole.</p>";
        }
    } else {
        echo "<p class='error'>Lietotājs nav atrasts.</p>";
    }

    $stmt->close();
}

$conn->close();
?>
