<?php

global $conn;
include 'db.php';


session_start();

if (!isset($_SESSION['user_id'])) {
    echo json_encode([]);
    exit;
}

$user_id = $_SESSION['user_id'];

$stmt = $conn->prepare("SELECT id, title, reminder_date, status FROM reminders WHERE user_id = ? ORDER BY reminder_date ASC");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();

$reminders = [];
while ($row = $result->fetch_assoc()) {
    $reminders[] = $row;
}

$stmt->close();
$conn->close();

header("Content-Type: application/json");
echo json_encode($reminders);
?>
