<?php
// Iekļaut datubāzes savienojumu
global $conn;
include 'db.php';

// Sākt sesiju
session_start();

// Pārbaudīt, vai lietotājs ir pieslēdzies
if (!isset($_SESSION['user_id'])) {
    echo json_encode([]);
    exit;
}

$user_id = $_SESSION['user_id'];

// Iegūt piezīmes lietotājam, kurš ir pieslēdzies
$stmt = $conn->prepare("SELECT title, content, created_at FROM notes WHERE user_id = ? ORDER BY created_at DESC");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();

$notes = [];
while ($row = $result->fetch_assoc()) {
    $notes[] = $row;
}

$stmt->close();
$conn->close();

// Atgriezt piezīmes JSON formātā
echo json_encode($notes);
?>
