<?php

global $conn;
include 'db.php';


session_start();

if (!isset($_SESSION['user_id'])) {
    echo json_encode([]);
    exit;
}

$user_id = $_SESSION['user_id'];

$stmt = $conn->prepare("SELECT title, meeting_date, reminder_time FROM meetings WHERE user_id = ? ORDER BY meeting_date ASC");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();

$meetings = [];
while ($row = $result->fetch_assoc()) {
    $meetings[] = $row;
}

$stmt->close();
$conn->close();

header("Content-Type: application/json");
echo json_encode($meetings);
?>
