<?php
// Iespējot kļūdu ziņošanu
global $conn;
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Iekļaut datubāzes savienojuma failu
include 'db.php';

// Iestatīt atbildes galveni JSON formātā
header("Content-Type: application/json");

// Atkodēt JSON ievadi
$data = json_decode(file_get_contents("php://input"), true);

if ($data === null) {
    echo json_encode(["success" => false, "error" => "Nav saņemti derīgi JSON dati"]);
    exit;
}

// Pārbaudīt ievadi
if (!isset($data['date']) || !isset($data['title']) || empty($data['date']) || empty($data['title'])) {
    echo json_encode(["success" => false, "error" => "Nederīga vai trūkstoša ievade"]);
    exit;
}

// Iegūt datus
$date = $data['date'];
$title = $data['title'];

// Sagatavot SQL vaicājumu notikuma ievietošanai
$stmt = $conn->prepare("INSERT INTO events (event_date, title) VALUES (?, ?)");
if (!$stmt) {
    echo json_encode(["success" => false, "error" => "SQL sagatavošana neizdevās: " . $conn->error]);
    exit;
}

$stmt->bind_param("ss", $date, $title);
