<?php
// Iespējot kļūdu ziņošanu
global $conn;
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Iekļaut datubāzes savienojuma failu
include 'db.php';

// Sākt sesiju
session_start();

// Pārbaudīt, vai lietotājs ir pieslēdzies
if (!isset($_SESSION['user_id'])) {
    header("Location: ../public/html/index.html"); // Novirzīt uz pieteikšanās lapu
    exit;
}

// Pārbaudīt, vai forma tika iesniegta
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $user_id = $_SESSION['user_id'];
    $title = $_POST['title'];
    $reminder_date = $_POST['reminder_date'];

    // Pārbaudīt, vai ievades lauki nav tukši
    if (!empty($title) && !empty($reminder_date)) {
        // Sagatavot SQL vaicājumu atgādinājuma saglabāšanai
        $stmt = $conn->prepare("INSERT INTO reminders (user_id, title, reminder_date, status) VALUES (?, ?, ?, 'pending')");
        $stmt->bind_param("iss", $user_id, $title, $reminder_date);

        if ($stmt->execute()) {
            header("Location: ../public/html/reminders.html?success=1"); // Pāradresēt pēc veiksmīgas pievienošanas
            exit;
        } else {
            echo "Kļūda: " . $stmt->error; // Izvadīt kļūdas paziņojumu
        }

        $stmt->close();
    } else {
        echo "Visi lauki ir obligāti."; // Paziņot lietotājam par obligātiem laukiem
    }
}

$conn->close(); // Aizvērt datubāzes savienojumu
?>
