<?php
// Iespējot kļūdu ziņošanu atkļūdošanai
global $conn; // Globālais savienojuma mainīgais
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Iekļaut datubāzes savienojuma failu
include 'db.php';

// Sākt sesiju
session_start();

// Pārbaudīt, vai lietotājs ir pieslēdzies
if (!isset($_SESSION['user_id'])) {
    header("Location: ../public/html/index.html"); // Novirzīt uz pieteikšanās lapu, ja nav pieslēgts
    exit;
}

// Pārbaudīt, vai forma tika iesniegta
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $user_id = $_SESSION['user_id'];
    $title = $_POST['title'];
    $content = $_POST['content'];

    // Pārbaudīt, vai ievades lauki nav tukši
    if (!empty($title) && !empty($content)) {
        // Sagatavot SQL vaicājumu piezīmes saglabāšanai
        $stmt = $conn->prepare("INSERT INTO notes (user_id, title, content) VALUES (?, ?, ?)");
        $stmt->bind_param("iss", $user_id, $title, $content);

        if ($stmt->execute()) {
            header("Location: ../public/html/notes.html?success=1"); // Pāradresēt pēc veiksmīgas pievienošanas
            exit;
        } else {
            echo "Kļūda: " . $stmt->error; // Izvadīt kļūdas paziņojumu
        }

        $stmt->close();
    } else {
        echo "Visi lauki ir obligāti."; // Paziņot lietotājam par obligātiem laukiem
    }
}

$conn->close(); // Aizvērt datubāzes savienojumu
?>
