<?php
global $conn;
error_reporting(E_ALL);
ini_set('display_errors', 1);


include 'db.php';

// Sāk sesiju
session_start();

// Pārbaidīt vai lietotājs ir pierakstījies
if (!isset($_SESSION['user_id'])) {
    header("Location: ../public/index.html");
    exit;
}

//Pārbauda vai veidlapa ir iesniegta
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $user_id = $_SESSION['user_id'];
    $title = $_POST['title'];
    $meeting_date = $_POST['meeting_date'];
    $reminder_time = !empty($_POST['reminder_time']) ? $_POST['reminder_time'] : NULL;

    if (!empty($title) && !empty($meeting_date)) {
        $stmt = $conn->prepare("INSERT INTO meetings (user_id, title, meeting_date, reminder_time) VALUES (?, ?, ?, ?)");
        $stmt->bind_param("isss", $user_id, $title, $meeting_date, $reminder_time);

        if ($stmt->execute()) {
            header("Location: ../public/html/schedule.html?success=1");
            exit;
        } else {
            echo "Error: " . $stmt->error;
        }

        $stmt->close();
    } else {
        echo "All fields are required.";
    }
}

$conn->close();
?>
