document.addEventListener("DOMContentLoaded", function () {
    const dueTasksSection = document.getElementById("due-tasks-section");
    const taskList = document.getElementById("task-list");
    const notesSection = document.getElementById("notes-section");
    const noteList = document.getElementById("note-list");
    const calendar = document.getElementById("calendar");

    const tasks = [
        { title: "Finish project report", dueDate: "2024-10-26" },
        { title: "Prepare for meeting", dueDate: "2024-10-27" },
    ];

    const notes = [
        { title: "Project meeting notes", date: "2024-10-26" },
    ];

    const today = new Date().toISOString().split("T")[0];

    // Display tasks due today
    const dueTodayTasks = tasks.filter(task => task.dueDate === today);
    if (dueTodayTasks.length) {
        dueTasksSection.classList.add("show-section");
        dueTodayTasks.forEach(task => {
            const li = document.createElement("li");
            li.textContent = task.title;
            taskList.appendChild(li);
        });
    }

    // Display notes if available
    if (notes.length) {
        notesSection.classList.add("show-section");
        notes.forEach(note => {
            const li = document.createElement("li");
            li.textContent = note.title;
            noteList.appendChild(li);
        });
    }

    // Generate a simple calendar with highlighted dates for tasks
    const daysInMonth = 31;
    for (let day = 1; day <= daysInMonth; day++) {
        const dateDiv = document.createElement("div");
        dateDiv.classList.add("calendar-date");
        dateDiv.textContent = day;

        // Check if this date has any tasks
        const dateStr = `2024-10-${String(day).padStart(2, "0")}`;
        if (tasks.some(task => task.dueDate === dateStr)) {
            dateDiv.classList.add("has-task");
        }

        calendar.appendChild(dateDiv);
    }

    // Handle adding new tasks and notes (simplified for this example)
    document.getElementById("event-form").addEventListener("submit", function (e) {
        e.preventDefault();
        const eventTitle = document.getElementById("event-title").value;
        const eventDate = document.getElementById("event-date").value;
        const eventNote = document.getElementById("event-note").value;

        // Add new task to calendar and note list
        tasks.push({ title: eventTitle, dueDate: eventDate });
        if (eventNote) {
            notes.push({ title: eventNote, date: eventDate });
        }

        // Reload page to display new data (or update dynamically)
        location.reload();
    });
});
