<?php
header('Content-Type: application/json');
session_start();
include 'db_config.php';

function registerUser($username, $email, $password, $role_id) {
    global $conn;

    // Šifrē paroli, lai to saglabātu droši
    $hashedPassword = password_hash($password, PASSWORD_BCRYPT);

    try {
        $query = "INSERT INTO users (username, email, password, role_id) VALUES (:username, :email, :password, :role_id)";
        $stmt = $conn->prepare($query);
        $stmt->bindParam(':username', $username);
        $stmt->bindParam(':email', $email);
        $stmt->bindParam(':password', $hashedPassword);
        $stmt->bindParam(':role_id', $role_id);

        return $stmt->execute();
    } catch (PDOException $e) {
        // Atgriež kļūdas ziņu JSON formātā, ja ir izņēmums
        echo json_encode(['success' => false, 'message' => 'Kļūda reģistrējot lietotāju: ' . $e->getMessage()]);
        exit();
    }
}

// Apstrādā reģistrācijas pieprasījumu
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['username'];
    $email = $_POST['email'];
    $password = $_POST['password'];
    $role_id = $_POST['role'];

    // Validē formu laukus
    if (empty($username) || empty($email) || empty($password) || empty($role_id)) {
        echo json_encode(['success' => false, 'message' => 'Visi lauki ir jāaizpilda.']);
        exit();
    }

    // Izsauc funkciju, lai reģistrētu lietotāju
    if (registerUser($username, $email, $password, $role_id)) {
        echo json_encode(['success' => true, 'message' => 'Reģistrācija veiksmīga!']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Kļūda reģistrējot lietotāju.']);
    }
}
?>
