<?php
header('Content-Type: application/json'); // Ensures JSON response type
session_start();
error_reporting(E_ALL);           // Enable error reporting
ini_set('display_errors', 1);     // Display errors

include 'db_config.php';

// Check if the user is authenticated
if (!isset($_SESSION['user_id'])) {
    echo json_encode(['error' => 'Lietotājs nav autentificēts']);
    exit();
}

try {
    // Fetch user role from database
    $query = "SELECT role FROM users WHERE id = :user_id";
    $stmt = $conn->prepare($query);
    $stmt->bindParam(':user_id', $_SESSION['user_id']);
    $stmt->execute();
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($user) {
        echo json_encode(['role' => $user['role']]);
    } else {
        echo json_encode(['error' => 'Lietotāja loma netika atrasta']);
    }
} catch (PDOException $e) {
    echo json_encode(['error' => 'Kļūda datu iegūšanā: ' . $e->getMessage()]);
    exit();
}
?>
