<?php
header('Content-Type: application/json'); // Iestata JSON atbildes tipu
session_start();
include 'db_config.php';

// Pārbauda, vai lietotājs ir autentificēts
if (!isset($_SESSION['user_id'])) {
    echo json_encode(['error' => 'Lietotājs nav autentificēts']);
    exit();
}

try {
    // Iegūst tuvākos uzdevumus no datubāzes
    $query = "SELECT title, priority, due_date FROM tasks WHERE user_id = :user_id ORDER BY priority DESC, due_date ASC";
    $stmt = $conn->prepare($query);
    $stmt->bindParam(':user_id', $_SESSION['user_id']);
    $stmt->execute();
    $tasks = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode(['tasks' => $tasks]); // Atgriež uzdevumus JSON formātā
} catch (PDOException $e) {
    echo json_encode(['error' => 'Kļūda datu iegūšanā: ' . $e->getMessage()]);
    exit();
}
?>
