<?php
session_start();
include 'db_config.php';

// Funkcija, lai veiktu lietotāja pieteikšanās pārbaudi
function loginUser($username, $password) {
    global $conn;

    // Sagatavojam SQL vaicājumu, lai iegūtu lietotāja datus pēc lietotājvārda
    $query = "SELECT * FROM users WHERE username = :username";
    $stmt = $conn->prepare($query);
    $stmt->bindParam(':username', $username);
    $stmt->execute();

    // Iegūstam lietotāja datus no datubāzes
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    // Pārbaudām, vai lietotājs eksistē un vai parole ir pareiza
    if ($user) {
        // Debug: Izvads, lai pārbaudītu saglabāto paroli un pārbaudes rezultātu
        error_log("Saglabātā parole hash: " . $user['password']); // Pārbaudām saglabāto hash
        error_log("Ievadītā parole: " . $password); // Pārbaudām ievadīto paroli

        // Veicam paroles pārbaudi ar password_verify
        if (password_verify($password, $user['password'])) {
            // Ja paroles pārbaude ir veiksmīga, saglabājam lietotāja ID un lomu sesijā
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['username'] = $user['username'];
            $_SESSION['role_id'] = $user['role_id'];
            return true; // Atgriež pieteikšanās veiksmi
        } else {
            error_log("Paroles verifikācija neizdevās."); // Debug: paroles pārbaude neizdevās
        }
    } else {
        error_log("Lietotājs nav atrasts."); // Debug: lietotājs nav atrasts
    }
    return false;
}

// Apstrādā pieteikšanās pieprasījumu
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['username'];
    $password = $_POST['password'];

    // Izsauc loginUser funkciju un atgriež JSON atbildi atkarībā no rezultāta
    if (loginUser($username, $password)) {
        echo json_encode(['success' => true, 'message' => 'Pieteikšanās veiksmīga']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Nepareizs lietotājvārds vai parole']);
    }
    exit();
}
?>
