<?php
header('Content-Type: application/json');
include 'db_config.php';

$data = json_decode(file_get_contents('php://input'), true);

if (isset($data['name']) && !empty($data['name'])) {
    try {
        $query = "INSERT INTO roles (name) VALUES (:name)";
        $stmt = $conn->prepare($query);
        $stmt->bindParam(':name', $data['name']);
        $stmt->execute();

        $role_id = $conn->lastInsertId();

        echo json_encode(['success' => true, 'role_id' => $role_id]);
    } catch (PDOException $e) {
        echo json_encode(['success' => false, 'message' => 'Kļūda pievienojot lomu: ' . $e->getMessage()]);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Lomas nosaukums ir nepieciešams.']);
}
?>
