// user_management.js - Reģistrēšanās loģika ar lomu ielādi un kļūdu apstrādi

document.addEventListener('DOMContentLoaded', function() {
    const registerForm = document.getElementById('registerForm');
    const addRoleButton = document.getElementById('addRoleButton');
    const newRoleContainer = document.getElementById('newRoleContainer');
    const saveRoleButton = document.getElementById('saveRoleButton');
    const roleSelect = document.getElementById('role');

    // Ielādē lomas no datubāzes
    function loadRoles() {
        fetch('../php/fetch_roles.php')
            .then(response => {
                if (!response.ok) throw new Error('Servera atbilde nav veiksmīga');
                return response.json();
            })
            .then(data => {
                if (data.roles) {
                    data.roles.forEach(role => {
                        const option = document.createElement('option');
                        option.value = role.id;
                        option.textContent = role.name;
                        roleSelect.appendChild(option);
                    });
                } else {
                    console.error('Lomas ielādes kļūda:', data.error);
                }
            })
            .catch(error => console.error('Kļūda lomu ielādē:', error));
    }

    // Pārbauda, vai lomu izvēlne pastāv, un ielādē lomas
    if (roleSelect) {
        loadRoles();
    } else {
        console.error('Lomas izvēlne nav atrasta!');
    }

    // Pārbauda, vai forma eksistē, pirms pievieno notikumu klausītāju
    if (registerForm) {
        registerForm.addEventListener('submit', function(event) {
            event.preventDefault();

            const formData = new FormData(registerForm);

            fetch('../php/user_management.php', {
                method: 'POST',
                body: formData
            })
            .then(response => {
                if (!response.ok) throw new Error('Servera atbilde nav veiksmīga');
                return response.json();
            })
            .then(data => {
                if (data.success) {
                    window.location.href = 'login.html'; // Veiksmīgas reģistrācijas novirzīšana uz pieteikšanās lapu
                } else {
                    document.getElementById('errorMsg').innerText = data.message; // Parāda kļūdas ziņojumu
                }
            })
            .catch(error => {
                console.error('Kļūda reģistrēšanās laikā:', error);
                document.getElementById('errorMsg').innerText = 'Neizdevās reģistrēties.';
            });
        });
    } else {
        console.error('Reģistrēšanās forma nav atrasta!');
    }

    // Parāda jaunas lomas pievienošanas formu
    if (addRoleButton) {
        addRoleButton.addEventListener('click', function() {
            newRoleContainer.style.display = 'block';
        });
    } else {
        console.error('Poga "Pievienot Jaunu Lomu" nav atrasta!');
    }

    // Saglabā jauno lomu datubāzē
    if (saveRoleButton) {
        saveRoleButton.addEventListener('click', function() {
            const newRole = document.getElementById('newRole').value;

            if (newRole) {
                fetch('../php/add_role.php', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' },
                    body: JSON.stringify({ name: newRole })
                })
                .then(response => {
                    if (!response.ok) throw new Error('Servera atbilde nav veiksmīga');
                    return response.json();
                })
                .then(data => {
                    if (data.success) {
                        const option = document.createElement('option');
                        option.value = data.role_id;
                        option.textContent = newRole;
                        roleSelect.appendChild(option);
                        roleSelect.value = data.role_id;
                        newRoleContainer.style.display = 'none';
                    } else {
                        console.error(data.message);
                    }
                })
                .catch(error => console.error('Kļūda pievienojot jaunu lomu:', error));
            }
        });
    } else {
        console.error('Poga "Saglabāt Lomu" nav atrasta!');
    }
});
