// main.js - Iegūst lietotāja lomu pēc pieteikšanās un attēlo kļūdu, ja neizdodas iegūt

document.addEventListener('DOMContentLoaded', function() {
    fetchUserRole();
});

function fetchUserRole() {
    fetch('../php/get_user_role.php')
        .then(response => {
            if (!response.ok) {
                throw new Error('Servera atbilde nebija veiksmīga: ' + response.status);
            }
            return response.json();
        })
        .then(data => {
            if (data.error) {
                console.error('Kļūda:', data.error);
                alert('Neizdevas iegūt lietotāja lomu: ' + data.error);
            } else {
                console.log('Lietotāja loma:', data.role); // Pārbaude
            }
        })
        .catch(error => {
            console.error('Neizdevas iegūt lietotāja lomu:', error);
            alert('Neizdevas iegūt lietotāja lomu: ' + error.message);
        });
}

