// dashboard.js - Ield un parda uzdevumus ar papildu kdu apstrdi

document.addEventListener('DOMContentLoaded', function() {
    loadDashboard();
});

// Funkcija uzdevumu ieldei no servera
function loadDashboard() {
    fetch('../php/dashboard.php')
        .then(response => {
            if (!response.ok) {
                throw new Error('Servera atbilde nebija veiksmga: ' + response.status);
            }
            return response.json(); // Prveido atbildi par JSON formtu
        })
        .then(data => {
            if (data.error) {
                console.error('Kda:', data.error);
                alert('Kda: ' + data.error);
            } else {
                displayTasks(data.tasks); // Attlo uzdevumus
            }
        })
        .catch(error => {
            console.error('Panela ielade neizdevas:', error);
            alert('Panela ielade neizdevas: ' + error.message);
        });
}

// Funkcija uzdevumu attloanai
function displayTasks(tasks) {
    const taskContainer = document.getElementById('task-container');
    taskContainer.innerHTML = ''; // Notra esoos uzdevumus

    tasks.forEach(task => {
        let taskElement = document.createElement('div');
        taskElement.classList.add('task');
        taskElement.innerHTML = `
            <h3>${task.title}</h3>
            <p>Prioritte: ${task.priority}</p>
            <p>Termi: ${task.due_date}</p>
        `;
        taskContainer.appendChild(taskElement);
    });
}
