// calendar.js - FullCalendar 6.x inicializcija un notikumu prvaldba ar Vanilla JavaScript

document.addEventListener('DOMContentLoaded', function() {
    let calendarEl = document.getElementById('calendar');

    // Inicializ FullCalendar 6.x ar moderno JavaScript API
    let calendar = new FullCalendar.Calendar(calendarEl, {
        initialView: 'dayGridMonth',
        headerToolbar: {
            left: 'prev,next today',  // Navigcijas pogas
            center: 'title',          // Kalendra nosaukums
            right: 'dayGridMonth,timeGridWeek,timeGridDay'  // Skati
        },
        locale: 'lv', // Latvieu valoda kalendram

        // Notikuma pievienoana ar kliki uz datuma
        dateClick: function(info) {
            openModal(info.dateStr); // Atver modli, lai pievienotu notikumu
        },

        // Notikumu ielde no servera
        events: {
            url: '../php/fetch_events.php', // Nordts servera ce notikumu ieganai
            failure: function() {
                alert('Notikumu ielde neizdevs'); // Paziojums par kdu, ja notikumi netiek ieldti
            }
        }
    });

    calendar.render(); // Rda kalendru
});

// Modla atvranas funkcija
function openModal(date) {
    let modal = document.getElementById('event-modal');
    if (modal) {
        modal.style.display = 'block';
        document.getElementById('event-date').value = date; // Iestata skuma datumu modlaj log
    } else {
        console.error("Modls logs netika atrasts");
    }
}

// Modla aizvranas funkcija
function closeModal() {
    let modal = document.getElementById('event-modal');
    if (modal) {
        modal.style.display = 'none';
        document.getElementById('event-form').reset(); // Notra formu pc aizvranas
    }
}

// Pievieno notikumu, kad forma tiek iesniegta
document.getElementById('event-form').addEventListener('submit', function(e) {
    e.preventDefault();

    const formData = new FormData(this);

    // Nosta datus uz serveri
    fetch('../php/add_event.php', {
        method: 'POST',
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            alert("Notikums veiksmgi pievienots!");
            closeModal();
            location.reload(); // Prld lapu, lai atjaunintu kalendru
        } else {
            alert("Kda pievienojot notikumu: " + data.message);
        }
    })
    .catch(error => console.error('Kda pievienojot notikumu:', error));
});
