<?php
// user_management.php - Pārvalda lietotāju pievienošanu, rediģēšanu un dzēšanu
include 'utilities/db_connection.php';
include 'utilities/session_manager.php';
include 'utilities/response_util.php';
if (!checkAuthenticated()) {
    sendError('Lietotājs nav autentificēts!');
}
if ($_SESSION['role'] !== 'admin') {
    sendError('Piekļuve liegta! Tikai administratori var veikt šo darbību.');
}
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Pievieno jaunu lietotāju
    $username = $_POST['username'];
    $password = password_hash($_POST['password'], PASSWORD_BCRYPT);
    $role = $_POST['role'];
    $query = $conn->prepare("INSERT INTO users (username, password, role_id) VALUES (:username, :password, :role)");
    $query->bindParam(':username', $username);
    $query->bindParam(':password', $password);
    $query->bindParam(':role', $role);
    $query->execute();
    sendJsonResponse(true, 'Lietotājs veiksmīgi pievienots!');
} elseif (isset($_GET['action']) && $_GET['action'] === 'get_users') {
    // Iegūst visus lietotājus
    $query = $conn->prepare("SELECT id, username, role_id FROM users");
    $query->execute();
    $users = $query->fetchAll(PDO::FETCH_ASSOC);
    sendJsonResponse(true, '', $users);
} elseif (isset($_GET['action']) && $_GET['action'] === 'delete_user') {
    // Dzēš lietotāju
    $userId = $_GET['id'];
    $query = $conn->prepare("DELETE FROM users WHERE id = :id");
    $query->bindParam(':id', $userId);
    $query->execute();
    sendJsonResponse(true, 'Lietotājs veiksmīgi dzēsts!');
}
?>
