<?php
// roles_management.php - Pārvalda lomu pievienošanu un ielādi
include 'db_config.php';
session_start();
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    echo json_encode(['success' => false, 'message' => 'Piekļuve liegta.']);
    exit();
}
// Pievieno jaunu lomu
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $roleName = $_POST['role_name'];
    $query = $conn->prepare("INSERT INTO roles (name) VALUES (:role_name)");
    $query->bindParam(':role_name', $roleName);
    if ($query->execute()) {
        echo json_encode(['success' => true, 'message' => 'Loma pievienota veiksmīgi.']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Kļūda pievienojot lomu.']);
    }
    exit();
}
// Iegūst visas lomas
if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $query = $conn->prepare("SELECT * FROM roles");
    $query->execute();
    $roles = $query->fetchAll(PDO::FETCH_ASSOC);
    echo json_encode($roles);
    exit();
}
?>
