<?php
// fetch_task.php - Iegūst lietotāja uzdevumus
include 'utilities/db_connection.php';
include 'utilities/session_manager.php';
include 'utilities/response_util.php';
try {
    if (!checkAuthenticated()) {
        sendError('Lietotājs nav autentificēts!');
    }
    $user_id = getUserId(); // Iegūst lietotāja ID no sesijas
    $category = $_GET['category'] ?? 'all';
    $priority = $_GET['priority'] ?? 'all';
    $query = "
        SELECT e.title, e.start_time, e.end_time, c.name AS category, e.priority,
               DATE(e.start_time) AS date
        FROM events e
        JOIN calendar_users cu ON e.calendar_id = cu.calendar_id
        JOIN categories c ON e.category_id = c.id
        WHERE cu.user_id = :user_id
    ";
    if ($category !== 'all') {
        $query .= " AND c.id = :category";
    }
    if ($priority !== 'all') {
        $query .= " AND e.priority = :priority";
    }
    $stmt = $conn->prepare($query);
    $stmt->bindParam(':user_id', $user_id);
    if ($category !== 'all') {
        $stmt->bindParam(':category', $category);
    }
    if ($priority !== 'all') {
        $stmt->bindParam(':priority', $priority);
    }
    $stmt->execute();
    $tasks = $stmt->fetchAll(PDO::FETCH_ASSOC);
    if (!empty($tasks)) {
        sendJsonResponse(true, '', $tasks);
    } else {
        sendJsonResponse(true, 'Nav atrasti uzdevumi.', []);
    }
} catch (PDOException $e) {
    sendError('Kļūda ielādējot uzdevumus: ' . $e->getMessage());
}
?>
