<?php
// Iekļauj datubāzes konfigurāciju
include 'db_config.php';
header('Content-Type: application/json');
// Pārbauda, vai lietotājs ir autentificēts
session_start();
if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'Lietotājs nav autentificēts!']);
    exit;
}
try {
    // Iegūst visus pieejamos kategorijas no datubāzes
    $stmt = $conn->prepare("SELECT id, name FROM categories");
    $stmt->execute();
    $categories = $stmt->fetchAll(PDO::FETCH_ASSOC);
    if ($categories) {
        echo json_encode(['success' => true, 'data' => $categories]); // Atgriež kategorijas
    } else {
        echo json_encode(['success' => true, 'data' => []]); // Ja nav kategoriju
    }
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Kļūda serverī: ' . $e->getMessage()]);
}
?>
