<?php
// edit_event.php - Funkcija esoša notikuma rediģēšanai
include 'utilities/db_connection.php';
include 'utilities/session_manager.php';
include 'utilities/response_util.php';
if (!checkAuthenticated()) {
    sendError('Lietotājs nav autentificēts!');
}
$event_id = $_POST['event-id'] ?? null;
$title = $_POST['eventName'] ?? null;
$start_date = $_POST['date'] ?? null;
$end_date = $_POST['end_date'] ?? $start_date;
$start_time = $_POST['start_time'] ?? null;
$end_time = $_POST['end_time'] ?? null;
$category_id = $_POST['category'] ?? null;
$priority = $_POST['priority'] ?? 'Low';
if (empty($event_id) || empty($title) || empty($start_date) || empty($start_time) || empty($category_id)) {
    sendError('Visi obligātie lauki ir jāaizpilda!');
}
// Rediģē notikumu datubāzē
$stmt = $conn->prepare("
    UPDATE events SET 
        title = :title, 
        start_date = :start_date, 
        end_date = :end_date, 
        start_time = :start_time, 
        end_time = :end_time, 
        category_id = :category_id, 
        priority = :priority
    WHERE id = :event_id AND user_id = :user_id
");
$stmt->bindParam(':title', $title);
$stmt->bindParam(':start_date', $start_date);
$stmt->bindParam(':end_date', $end_date);
$stmt->bindParam(':start_time', $start_time);
$stmt->bindParam(':end_time', $end_time);
$stmt->bindParam(':category_id', $category_id);
$stmt->bindParam(':priority', $priority);
$stmt->bindParam(':event_id', $event_id);
$stmt->bindParam(':user_id', getUserId());
$stmt->execute();
sendJsonResponse(true, 'Notikums veiksmīgi atjaunināts!');
?>
