<?php
// calendar.php - Iegūst lietotāja pieejamos kalendārus
include 'utilities/db_connection.php';
include 'utilities/session_manager.php';
include 'utilities/response_util.php';
if (!checkAuthenticated()) {
    sendError('Lietotājs nav autentificēts!');
}
try {
    $user_id = $_SESSION['user_id']; // Pārbauda lietotāja ID no sesijas
    // Iegūst lietotāja pieejamos kalendārus
    $stmt = $conn->prepare("
        SELECT c.id, c.name
        FROM calendars c
        INNER JOIN calendar_users cu ON c.id = cu.calendar_id
        WHERE cu.user_id = :user_id
    ");
    $stmt->bindParam(':user_id', $user_id);
    $stmt->execute();
    $calendars = $stmt->fetchAll(PDO::FETCH_ASSOC);
    if ($calendars) {
        sendJsonResponse(true, '', $calendars);
    } else {
        sendJsonResponse(true, 'Nav pieejamu kalendāru.', []);
    }
} catch (Exception $e) {
    sendError('Kļūda iegūstot kalendārus: ' . $e->getMessage());
}
?>
