<?php
// auth.php - Pārbauda lietotāja autentifikāciju
include 'utilities/db_connection.php';
include 'utilities/session_manager.php';
include 'utilities/response_util.php';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);
    $username = $input['username'] ?? null;
    $password = $input['password'] ?? null;
    if (empty($username) || empty($password)) {
        sendError('Visi lauki ir jāaizpilda!');
    }
    $query = $conn->prepare("SELECT * FROM users WHERE username = :username");
    $query->bindParam(':username', $username);
    $query->execute();
    $user = $query->fetch(PDO::FETCH_ASSOC);
    if ($user && password_verify($password, $user['password'])) {
        session_start();
        $_SESSION['user_id'] = $user['id'];
        $_SESSION['username'] = $user['username'];
        $_SESSION['role_id'] = $user['role_id'];
        sendJsonResponse(true, 'Autentifikācija veiksmīga!');
    } else {
        sendError('Nepareizs lietotājvārds vai parole.');
    }
}
?>
