<?php
// add_role.php - Jaunas lomas pievienošana
include 'utilities/db_connection.php';
include 'utilities/session_manager.php';
include 'utilities/response_util.php';
if (!checkAuthenticated()) {
    sendError('Lietotājs nav autentificēts!');
}
if ($_SESSION['role'] !== 'admin') {
    sendError('Piekļuve liegta. Tikai administratori var pievienot lomas!');
}
$roleName = $_POST['role_name'] ?? null;
if (empty($roleName)) {
    sendError('Lomas nosaukums ir jāaizpilda!');
}
// Pievieno jaunu lomu
$query = $conn->prepare("INSERT INTO roles (role_name) VALUES (:role_name)");
$query->bindParam(':role_name', $roleName);
$query->execute();
sendJsonResponse(true, 'Loma veiksmīgi pievienota!');
?>
