<?php
// add_comment.php - Komentāra pievienošana notikumam
include 'utilities/db_connection.php';
include 'utilities/session_manager.php';
include 'utilities/response_util.php';
if (!checkAuthenticated()) {
    sendError('Lietotājs nav autentificēts!');
}
$event_id = $_POST['event_id'] ?? null;
$comment = $_POST['comment'] ?? null;
if (empty($event_id) || empty($comment)) {
    sendError('Visi obligātie lauki ir jāaizpilda!');
}
// Ievieto komentāru datubāzē
$stmt = $conn->prepare("
    INSERT INTO comments (event_id, user_id, comment, created_at)
    VALUES (:event_id, :user_id, :comment, NOW())
");
$stmt->bindParam(':event_id', $event_id);
$stmt->bindParam(':user_id', $_SESSION['user_id']);
$stmt->bindParam(':comment', $comment);
$stmt->execute();
sendJsonResponse(true, 'Komentārs veiksmīgi pievienots!');
?>
