document.addEventListener('DOMContentLoaded', function () {
    loadUsers();  // Ielādē visus lietotājus

    // Pievieno jaunu lietotāju
    document.getElementById('add-user-form').addEventListener('submit', function (event) {
        event.preventDefault();
        const formData = new FormData(this);
        fetch('../php/user_management.php', {
            method: 'POST',
            body: formData,
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert('Lietotājs veiksmīgi pievienots!');
                loadUsers();
            } else {
                alert('Kļūda pievienojot lietotāju: ' + data.message);
            }
        })
        .catch(error => console.error('Kļūda pievienojot lietotāju:', error));
    });
});

// Ielādē visus lietotājus
function loadUsers() {
    fetch('../php/user_management.php?action=get_users')
        .then(response => response.json())
        .then(data => {
            const userList = document.getElementById('user-list').querySelector('tbody');
            userList.innerHTML = ''; // Notīra esošo lietotāju sarakstu
            data.forEach(user => {
                const row = document.createElement('tr');
                row.innerHTML = `
                    <td>${user.username}</td>
                    <td>${user.role}</td>
                    <td>
                        <button onclick="deleteUser(${user.id})">Dzēst</button>
                        <button onclick="editUser(${user.id})">Rediģēt</button>
                    </td>
                `;
                userList.appendChild(row);
            });
        })
        .catch(error => console.error('Kļūda ielādējot lietotājus:', error));
}
// Dzēš lietotāju
function deleteUser(userId) {
    fetch(`../php/user_management.php?action=delete_user&id=${userId}`, { method: 'GET' })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert('Lietotājs veiksmīgi dzēsts!');
                loadUsers();
            } else {
                alert('Kļūda dzēšot lietotāju: ' + data.message);
            }
        })
        .catch(error => console.error('Kļūda dzēšot lietotāju:', error));
}
