// Pārliecināmies, ka viss saturs ir ielādēts pirms kategoriju ielādes
document.addEventListener('DOMContentLoaded', function() {
    // Funkcija, lai ielādētu kategorijas no servera
    loadCategories();
});
// Funkcija kategoriju ielādei
function loadCategories() {
    // Iegūstam kategoriju izvēlni (select elements)
    const categorySelect = document.getElementById('event-category');
    if (!categorySelect) {
        console.error("Kategoriju izvēlne netika atrasta");
        return; // Ja izvēlne nav atrasta, izbeidzam funkciju
    }
    fetch('../php/fetch_categories.php') // Pieprasām kategorijas no servera
        .then(response => response.json()) // Pārvēršam atbildi JSON formātā
        .then(data => {
            categorySelect.innerHTML = ''; // Notīrām esošās kategorijas
            // Pārbaudām, vai dati ir pieejami
            if (data && data.data && data.data.length > 0) {
                // Ja dati ir, pievienojam tās izvēlnei
                data.data.forEach(category => {
                    const option = document.createElement('option');
                    option.value = category.id; // Iestata kategorijas ID
                    option.textContent = category.name; // Iestata kategorijas nosaukumu
                    categorySelect.appendChild(option); // Pievienojam izvēlnei
                });
            } else {
                // Ja nav kategoriju, parādām ziņu
                const option = document.createElement('option');
                option.textContent = 'Nav kategoriju';
                categorySelect.appendChild(option);
            }
        })
        .catch(error => {
            console.error('Kļūda ielādējot kategorijas:', error); // Ja rodas kļūda, izvadām kļūdu konsolē
            alert('Kļūda ielādējot kategorijas');
        });
}
