document.addEventListener('DOMContentLoaded', function () {
    loadCategories();  // Ielādē kategorijas, kad tiek atvērta lapa
});
// Ielādē kategorijas no servera
function loadCategories() {
    fetch('../php/fetch_categories.php')
        .then(response => response.json())
        .then(data => {
            const categorySelect = document.getElementById('event-category');
            categorySelect.innerHTML = '<option value="">Izvēlieties kategoriju</option>';
            data.forEach(category => {
                const option = document.createElement('option');
                option.value = category.id;
                option.textContent = category.name;
                categorySelect.appendChild(option);
            });
        })
        .catch(error => console.error('Kļūda ielādējot kategorijas:', error));
}
