<?php
// get_user_role.php - Iegūst lietotāja lomu
include 'utilities/db_connection.php';
include 'utilities/session_manager.php';
include 'utilities/response_util.php';
try {
    if (!checkAuthenticated()) {
        sendError('Lietotājs nav autentificēts!');
    }
    $user_id = getUserId(); // Iegūst lietotāja ID no sesijas
    $stmt = $conn->prepare("
SELECT 
    r.name as role_name
FROM 
    users u
JOIN 
    roles r 
    ON u.role_id = r.id
WHERE 
    u.id = :user_id
    ");
    $stmt->bindParam(':user_id', $user_id);
    $stmt->execute();
    $role = $stmt->fetch(PDO::FETCH_ASSOC);
    if ($role) {
        sendJsonResponse(true, '', ['role' => $role['role_name']]);
    } else {
        sendError('Loma nav atrasta.');
    }
} catch (Exception $e) {
    sendError('Kļūda iegūstot lomu: ' . $e->getMessage());
}
?>
