<?php
include 'db_config.php';
header('Content-Type: application/json');
session_start();
if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'Lietotājs nav autentificēts!']);
    exit;
}
// Iegūst lietotāja ID
$user_id = $_SESSION['user_id'];
// Iegūst notikumus no datubāzes
try {
    $stmt = $conn->prepare("
        SELECT e.id, e.title, e.start_time, e.end_time, c.name as category, e.priority
        FROM events e
        JOIN categories c ON e.category_id = c.id
        WHERE e.user_id = :user_id
    ");
    $stmt->bindParam(':user_id', $user_id);
    $stmt->execute();
    $events = [];
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $events[] = [
            'id' => $row['id'],
            'title' => $row['title'],
            'start' => $row['start_time'],
            'end' => $row['end_time'],
            'category' => $row['category'],
            'priority' => $row['priority']
        ];
    }
    echo json_encode(['success' => true, 'data' => $events]);
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Kļūda: ' . $e->getMessage()]);
}
?>
