<?php
// fetch_comments.php - Iegūst komentārus konkrētiem notikumiem
include 'utilities/db_connection.php';
include 'utilities/session_manager.php';
include 'utilities/response_util.php';
// Pārbauda, vai lietotājs ir autentificēts
if (!checkAuthenticated()) {
    sendError('Lietotājs nav autentificēts!');
}
$event_id = $_GET['event_id'] ?? null;  // Saņem notikuma ID no pieprasījuma
// Pārbauda, vai ir norādīts notikuma ID
if (empty($event_id)) {
    sendError('Nav norādīts notikuma ID!');
}
// Iegūst komentārus par konkrēto notikumu no datubāzes
$query = $conn->prepare("
    SELECT c.comment, c.created_at, u.username
    FROM comments c
    JOIN users u ON c.user_id = u.id
    WHERE c.event_id = :event_id
    ORDER BY c.created_at ASC
");
$query->bindParam(':event_id', $event_id);
$query->execute();
$comments = $query->fetchAll(PDO::FETCH_ASSOC);
// Ja komentāri ir, nosūta tos kā atbildi
sendJsonResponse(true, '', $comments);
?>
