<?php
// dashboard.php - Iegūst uzdevumus un kalendārus dashboard lapai
include 'utilities/db_connection.php';
include 'utilities/session_manager.php';
include 'utilities/response_util.php';
if (!checkAuthenticated()) {
    sendError('Lietotājs nav autentificēts!');
}
$userId = getUserId();
$query = $conn->prepare("
    SELECT title, start_date, priority
    FROM events
    WHERE user_id = :user_id
    ORDER BY FIELD(priority, 'High', 'Medium', 'Low')
");
$query->bindParam(':user_id', $userId);
$query->execute();
$tasks = $query->fetchAll(PDO::FETCH_ASSOC);
sendJsonResponse(true, '', $tasks);
?>
