<?php
// Iekļauj utilītas datubāzes savienojumam un sesijas pārvaldībai
require_once 'utilities/db_connection.php';
require_once 'utilities/session_manager.php';
require_once 'utilities/response_util.php';
checkAuthenticated(); // Pārbauda, vai lietotājs ir autentificēts
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Iegūst POST datus
    $userId = getUserId(); // Pašreizējā lietotāja ID
    $calendarId = $_POST['calendar_id'] ?? null;
    $title = $_POST['eventName'] ?? null;
    $startDate = $_POST['start_date'] ?? null;
    $startTime = $_POST['start_time'] ?? null;
    $endDate = $_POST['end_date'] ?? $startDate; // Ja nav norādīts, tiek izmantots sākuma datums
    $endTime = $_POST['end_time'] ?? null;
    $categoryId = $_POST['category'] ?? null;
    $priority = $_POST['priority'] ?? 'Low';
    // Validē ievades datus
    if (empty($calendarId) || empty($title) || empty($startDate) || empty($startTime) || empty($categoryId)) {
        sendError('Visi obligātie lauki ir jāaizpilda!');
    }
    try {
        // Apstrādā beigu laiku, ja tas nav norādīts
        $finalEndTime = $endTime ?? $startTime;
        // Pievieno notikumu datubāzē
        $stmt = $conn->prepare("
            INSERT INTO events (calendar_id, user_id, title, start_time, end_time, category_id, priority)
            VALUES (:calendar_id, :user_id, :title, :start_time, :end_time, :category_id, :priority)
        ");
        $stmt->execute([
            ':calendar_id' => $calendarId,
            ':user_id' => $userId,
            ':title' => $title,
            ':start_time' => $startDate . ' ' . $startTime,
            ':end_time' => $endDate . ' ' . $finalEndTime,
            ':category_id' => $categoryId,
            ':priority' => $priority
        ]);
        sendJsonResponse(['success' => true, 'message' => 'Notikums veiksmīgi pievienots!']);
    } catch (PDOException $e) {
        sendError('Kļūda pievienojot notikumu: ' . $e->getMessage());
    }
}
?>
