<?php
// Pievieno jaunu kategoriju
include 'db_config.php';
header('Content-Type: application/json');
session_start();
if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'Lietotājs nav autentificēts!']);
    exit;
}
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $categoryName = $_POST['categoryName'] ?? null;
    if (empty($categoryName)) {
        echo json_encode(['success' => false, 'message' => 'Kategorijas nosaukums ir jānorāda!']);
        exit;
    }
    try {
        $stmt = $conn->prepare("INSERT INTO categories (name) VALUES (:categoryName)");
        $stmt->bindParam(':categoryName', $categoryName);
        $stmt->execute();
        echo json_encode(['success' => true, 'message' => 'Jauna kategorija veiksmīgi pievienota!']);
    } catch (Exception $e) {
        echo json_encode(['success' => false, 'message' => 'Kļūda pievienojot kategoriju: ' . $e->getMessage()]);
    }
}
?>
