// sidebar.js - Ielādē kalendārus un pārbauda lietotāja lomu
document.addEventListener('DOMContentLoaded', function () {
    loadCalendars();
    checkAdminRole();
});
// Ielādē lietotājam pieejamos kalendārus
function loadCalendars() {
    fetch('../php/calendar.php')
        .then(response => {
            if (!response.ok) {
                throw new Error('Servera kļūda: ' + response.status);
            }
            return response.json();
        })
        .then(data => {
            const calendarList = document.getElementById('calendarList');
            calendarList.innerHTML = ''; // Notīra esošo sarakstu
            if (data.success && Array.isArray(data.data)) {
                data.data.forEach(calendar => {
                    const listItem = document.createElement('li');
                    listItem.innerHTML = `<a href="calendar_view.html?calendar_id=${calendar.id}">${calendar.name}</a>`;
                    calendarList.appendChild(listItem);
                });
            } else {
                calendarList.innerHTML = '<li>Nav pieejamu kalendāru</li>';
            }
        })
        .catch(error => console.error('Kļūda ielādējot kalendārus:', error));
}
// Pārbauda, vai lietotājs ir administrators
function checkAdminRole() {
    fetch('../php/get_user_role.php')
        .then(response => {
            if (!response.ok) {
                throw new Error('Servera kļūda: ' + response.status);
            }
            return response.json();
        })
        .then(data => {
            if (data.success && data.data.role === 'admin') {
                document.getElementById('userManagementBtn').style.display = 'block';
            }
        })
        .catch(error => console.error('Kļūda pārbaudot lietotāja lomu:', error));
}
