document.getElementById('login-form').addEventListener('submit', function (e) {
    e.preventDefault(); // Aizkavē noklusējuma darbību
    const username = document.getElementById('username').value.trim();
    const password = document.getElementById('password').value.trim();
    
    // Nosūta pieteikšanās datus uz serveri
    fetch('../php/auth.php', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify({ username, password }) // Nosūta JSON formātā
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            window.location.href = 'dashboard.html'; // Pāriet uz dashboard
        } else {
            document.getElementById('errorMsg').innerText = data.message; // Parāda kļūdas ziņojumu
        }
    })
    .catch(error => {
        console.error('Kļūda pieprasījumā:', error);
        document.getElementById('errorMsg').innerText = 'Kļūda serverī.';
    });
});
