// dashboard.js - Paneļa funkcionalitāte
document.addEventListener('DOMContentLoaded', function () {
    loadTasks();
    // Pievieno klausītājus filtru izmaiņām
    document.getElementById('event-category').addEventListener('change', loadTasks);
    document.getElementById('priorityFilter').addEventListener('change', loadTasks);
});
// Ielādē uzdevumus no servera
function loadTasks() {
    const category = document.getElementById('event-category').value;
    const priority = document.getElementById('priorityFilter').value;
    fetch(`../php/fetch_task.php?category=${category}&priority=${priority}`)
        .then(response => {
            if (!response.ok) {
                throw new Error('Servera kļūda: ' + response.status);
            }
            return response.json();
        })
        .then(data => {
            const taskList = document.getElementById('task-list');
            taskList.innerHTML = ''; // Notīra esošos uzdevumus
            if (data.success && data.data.length > 0) {
                data.data.forEach(task => {
                    const taskElement = document.createElement('div');
                    taskElement.className = 'task-item ' + getPriorityClass(task.priority);
                    taskElement.innerHTML = `
                        <h3>${task.title}</h3>
                        <p>Kategorija: ${task.category}</p>
                        <p>Prioritāte: ${task.priority}</p>
                        <p>Datums: ${task.date}</p>
                    `;
                    taskList.appendChild(taskElement);
                });
            } else {
                taskList.innerHTML = '<p>Nav atrasti uzdevumi.</p>';
            }
        })
        .catch(error => console.error('Paneļa ielādes kļūda:', error));
}
// Atgriež CSS klasi atkarībā no prioritātes
function getPriorityClass(priority) {
    if (priority === 'High') return 'high-priority';
    if (priority === 'Medium') return 'medium-priority';
    return 'low-priority';
}
