document.addEventListener('DOMContentLoaded', function () {
    // Ielādē visus komentārus, kad lapa tiek ielādēta
    loadComments();
    // Pievieno jaunu komentāru, kad forma tiek iesniegta
    document.getElementById('comment-form').addEventListener('submit', function (e) {
        e.preventDefault();  // Aizkavē formu noklusēto iesniegšanu
        const formData = new FormData(this);
        // Nosūta datus uz serveri, lai pievienotu komentāru
        fetch('../php/add_comment.php', {
            method: 'POST',
            body: formData
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert('Komentārs veiksmīgi pievienots!');
                loadComments();  // Pārlādē komentārus, lai redzētu pievienoto
            } else {
                alert('Kļūda pievienojot komentāru: ' + data.message);
            }
        })
        .catch(error => console.error('Kļūda pievienojot komentāru:', error));
    });
});
// Funkcija, lai ielādētu komentārus no servera
function loadComments() {
    fetch('../php/fetch_comments.php')
        .then(response => response.json())
        .then(data => {
            const commentList = document.getElementById('comment-list');
            commentList.innerHTML = ''; // Notīra esošo komentāru sarakstu
            // Pārliecinās, vai atgrieztais rezultāts ir masīvs
            if (Array.isArray(data)) {
                // Ielādē komentārus no servera
                data.forEach(comment => {
                    const commentItem = document.createElement('div');
                    commentItem.className = 'comment-item';
                    commentItem.innerHTML = `
                        <p><strong>${comment.username}</strong>: ${comment.comment}</p>
                        <p><small>Izveidots: ${comment.created_at}</small></p>
                        <button onclick="deleteComment(${comment.id})">Dzēst komentāru</button>
                    `;
                    commentList.appendChild(commentItem);
                });
            } else {
                commentList.innerHTML = '<p>Nav pieejamu komentāru.</p>';
            }
        })
        .catch(error => {
            console.error('Kļūda ielādējot komentārus:', error);
            alert('Komentāru ielāde neizdevās.');
        });
}
// Funkcija komentāra dzēšanai
function deleteComment(commentId) {
    if (confirm('Vai tiešām vēlaties dzēst šo komentāru?')) {
        fetch(`../php/delete_comment.php?id=${commentId}`, { method: 'GET' })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    alert('Komentārs veiksmīgi dzēsts!');
                    loadComments();  // Pārlādē komentāru sarakstu
                } else {
                    alert('Kļūda dzēšot komentāru: ' + data.message);
                }
            })
            .catch(error => {
                console.error('Kļūda dzēšot komentāru:', error);
                alert('Kļūda dzēšot komentāru.');
            });
    }
}
