// Funkcija, kas inicializē FullCalendar un ielādē notikumus
document.addEventListener('DOMContentLoaded', function () {
    let calendarEl = document.getElementById('calendar'); // Iegūstam kalendāra konteineru
    let calendar = new FullCalendar.Calendar(calendarEl, {
        initialView: 'dayGridMonth', // Mēneša skats
        headerToolbar: {
            left: 'prev,next today', // Iepriekšējais, nākamais, šodien pogas
            center: 'title', // Virsraksts
            right: 'dayGridMonth,timeGridWeek,timeGridDay' // Skatu izvēle
        },
        locale: 'lv', // Valodas iestatījums
        timeZone: 'Europe/Riga', // Laika zona
        eventTimeFormat: {
            hour: '2-digit',
            minute: '2-digit',
            hour12: false // 24 stundu formāts
        },
        events: {
            url: '../php/fetch_events.php', // Adrese, kur ielādēt notikumus
            method: 'GET', // Notikumu ielāde izmantojot GET metodi
            failure: function () {
                alert('Notikumu ielāde neizdevās'); // Ja notikumu ielāde neizdodas
            },
            success: function (data) {
                // Iespējams, ka serveris atgriež "data.data", tāpēc pārliecināmies, ka notikumi tiek ielādēti pareizi
                if (data.success && data.data) {
                    console.log("Notikumi ielādēti: ", data.data);
                    // FullCalendar var izprast notikumus tikai tad, ja viņi ir pareizi sagatavoti
                    return data.data.map(event => ({
                        id: event.id,
                        title: event.title,
                        start: event.start, // sākuma datums un laiks
                        end: event.end, // beigu datums un laiks
                        description: event.description, // notikuma apraksts
                        category: event.category, // kategorija
                        priority: event.priority // prioritāte
                    }));
                }
            }
        },
        dateClick: function (info) {
            openModal('add', { date: info.dateStr }); // Atver modālo logu jauna notikuma pievienošanai
        },
        eventClick: function (info) {
            openModal('edit', info.event); // Atver modālo logu notikuma rediģēšanai
        }
    });
    calendar.render(); // Renderējam kalendāru
});
// Funkcija modāla loga atvēršanai pievienošanai vai rediģēšanai
function openModal(type, eventData) {
    const modal = document.getElementById('event-modal'); // Iegūstam modālo logu
    const eventForm = document.getElementById('event-form'); // Iegūstam notikuma formu
    modal.style.display = 'block'; // Padarām modālo logu redzamu
    if (type === 'add') {
        eventForm.reset(); // Notīra formu pievienošanai
        document.getElementById('event-date').value = eventData.date; // Iestata sākuma datumu
        loadCategories(); // Ielādējam kategorijas pievienošanai
    } else if (type === 'edit') {
        // Ja tiek rediģēts esošs notikums, aizpildām formu ar esošajiem datiem
        document.getElementById('event-id').value = eventData.id; // Iestata notikuma ID
        document.getElementById('eventName').value = eventData.title; // Iestata notikuma nosaukumu
        document.getElementById('event-date').value = eventData.startStr.split('T')[0]; // Sākuma datums
        document.getElementById('event-end-date').value = eventData.endStr.split('T')[0]; // Beigu datums
        document.getElementById('event-start-time').value = eventData.startStr.split('T')[1]; // Sākuma laiks
        document.getElementById('event-end-time').value = eventData.endStr.split('T')[1]; // Beigu laiks
        document.getElementById('event-category').value = eventData.extendedProps.category; // Kategorija
        document.getElementById('priority').value = eventData.extendedProps.priority; // Prioritāte
        loadCategories(); // Ielādējam kategorijas rediģēšanai
    }
}
// Funkcija modāla loga aizvēršanai
function closeModal() {
    const modal = document.getElementById('event-modal');
    modal.style.display = 'none'; // Paslēpjam modālo logu
    document.getElementById('event-form').reset(); // Notīrām formu
}
// Pievieno vai rediģē notikumu, kad forma tiek iesniegta
document.getElementById('event-form').addEventListener('submit', function (e) {
    e.preventDefault(); // Novērš noklusējuma formu iesniegšanu
    const formData = new FormData(this); // Iegūstam formas datus
    const eventId = formData.get('event-id'); // Iegūstam notikuma ID
    const url = eventId ? '../php/edit_event.php' : '../php/add_event.php'; // Izvēlamies, vai pievienot jaunu vai rediģēt esošu notikumu
    // Nosūtām datus uz serveri
    fetch(url, {
        method: 'POST',
        body: formData
    })
        .then(response => response.json()) // Pārveidojam atbildi JSON formātā
        .then(data => {
            if (data.success) {
                alert(data.message); // Ja viss ir veiksmīgi, parādām ziņu
                closeModal(); // Aizveram modālo logu
                calendar.refetchEvents(); // Atjaunojam kalendāra notikumus
            } else {
                alert('Kļūda pievienojot notikumu: ' + data.message); // Ja notikusi kļūda, parādām kļūdas ziņojumu
            }
        })
        .catch(error => console.error('Kļūda pievienojot notikumu:', error)); // Ja rodas kļūda, izvadām to konsolē
});
// Funkcija, lai ielādētu kategorijas no servera
function loadCategories() {
    fetch('../php/fetch_categories.php') // Pieprasām kategorijas no servera
        .then(response => response.json()) // Pārvēršam atbildi JSON formātā
        .then(data => {
            const categorySelect = document.getElementById('event-category');
            categorySelect.innerHTML = ''; // Notīrām esošās kategorijas
            if (data && data.length > 0) {
                data.forEach(category => {
                    const option = document.createElement('option');
                    option.value = category.id; // Iestata kategorijas ID
                    option.textContent = category.name; // Iestata kategorijas nosaukumu
                    categorySelect.appendChild(option); // Pievienojam jaunu kategoriju izvēlnei
                });
            } else {
                const option = document.createElement('option');
                option.textContent = 'Nav kategoriju'; // Ja nav kategoriju, parādām ziņu
                categorySelect.appendChild(option);
            }
        })
        .catch(error => {
            console.error('Kļūda ielādējot kategorijas:', error); // Ja rodas kļūda, izvadām kļūdu konsolē
            alert('Kļūda ielādējot kategorijas');
        });
}