// load_categories.js - Kategoriju ielade kalendara

document.addEventListener('DOMContentLoaded', function() {
    fetch('../php/fetch_categories.php')
        .then(response => response.json())
        .then(data => {
            let categorySelect = document.getElementById('categorySelect');
            data.forEach(category => {
                let option = document.createElement('option');
                option.value = category.id;
                option.text = category.name;
                categorySelect.add(option);
            });
        })
        .catch(error => console.error('Kategoriju ielade neizdevas:', error));
});
